/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.service.test.controller;

import io.americanexpress.synapse.framework.exception.ApplicationClientException;
import io.americanexpress.synapse.framework.exception.ApplicationServerException;
import io.americanexpress.synapse.framework.exception.model.ErrorCode;
import io.americanexpress.synapse.service.rest.model.BaseServiceRequest;
import io.americanexpress.synapse.service.rest.model.BaseServiceResponse;
import io.americanexpress.synapse.service.rest.service.BaseCreateService;
import io.americanexpress.synapse.service.test.controller.BaseControllerUnitTest;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public abstract class BaseCreateMonoControllerUnitTest<O extends BaseServiceResponse, I extends BaseServiceRequest, S extends BaseCreateService<I, O>>
extends BaseControllerUnitTest<O> {
    @MockBean
    protected S service;

    @Override
    protected String getSampleJsonResponseFileName() {
        return "";
    }

    @Test
    public void create_givenGoodResponseFromService_expectedSuccessfulResponse() throws Exception {
        BDDMockito.given((Object)this.service.create((BaseServiceRequest)ArgumentMatchers.any())).willReturn((Object)this.response);
        this.testEndpoint(this.getEndpoint(), HttpMethod.POST, HttpStatus.CREATED);
    }

    @Test
    public void create_givenApplicationClientExceptionThrownInServiceCall_expectedExceptionThrownInResponse() throws Exception {
        BDDMockito.given((Object)this.service.create((BaseServiceRequest)ArgumentMatchers.any())).willThrow(new Throwable[]{new ApplicationClientException("", ErrorCode.GENERIC_4XX_ERROR, new String[0])});
        this.testEndpoint(this.getEndpoint(), HttpMethod.POST, HttpStatus.BAD_REQUEST);
    }

    @Test
    public void create_givenApplicationServerExceptionThrownInServiceCall_expectedExceptionThrownInResponse() throws Exception {
        ClassNotFoundException classNotFoundException = new ClassNotFoundException();
        BDDMockito.given((Object)this.service.create((BaseServiceRequest)ArgumentMatchers.any())).willThrow(new Throwable[]{new ApplicationServerException((Throwable)classNotFoundException)});
        this.testEndpoint(this.getEndpoint(), HttpMethod.POST, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @Test
    public void create_givenNPEThrownInServiceCall_expectedExceptionThrownInResponse() throws Exception {
        BDDMockito.given((Object)this.service.create((BaseServiceRequest)ArgumentMatchers.any())).willThrow(new Throwable[]{new NullPointerException()});
        this.testEndpoint(this.getEndpoint(), HttpMethod.POST, HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

