/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.service.test.controller;

import io.americanexpress.synapse.framework.exception.ApplicationClientException;
import io.americanexpress.synapse.framework.exception.ApplicationServerException;
import io.americanexpress.synapse.framework.exception.model.ErrorCode;
import io.americanexpress.synapse.service.rest.model.BaseServiceRequest;
import io.americanexpress.synapse.service.rest.model.BaseServiceResponse;
import io.americanexpress.synapse.service.rest.service.BaseReadPolyService;
import io.americanexpress.synapse.service.test.controller.BaseControllerUnitTest;
import java.util.ArrayList;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.data.domain.PageImpl;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public abstract class BaseReadPolyControllerUnitTest<O extends BaseServiceResponse, I extends BaseServiceRequest, S extends BaseReadPolyService<I, O>>
extends BaseControllerUnitTest<O> {
    @MockBean
    protected S service;

    @Test
    public void read_givenGoodResponseFromService_expectedSuccessfulResponse() throws Exception {
        ArrayList<BaseServiceResponse> responses = new ArrayList<BaseServiceResponse>();
        responses.add(this.response);
        PageImpl pagedResponse = new PageImpl(responses);
        BDDMockito.given((Object)this.service.read((BaseServiceRequest)ArgumentMatchers.any())).willReturn((Object)pagedResponse);
        this.testEndpoint(this.getEndpoint(), HttpMethod.POST);
    }

    @Test
    public void read_givenEmptyResponseFromService_expectedNoContentResponse() throws Exception {
        BDDMockito.given((Object)this.service.read((BaseServiceRequest)ArgumentMatchers.any())).willReturn(null);
        this.testEndpoint(this.getEndpoint(), HttpMethod.POST, HttpStatus.NO_CONTENT);
    }

    @Test
    public void read_givenApplicationClientExceptionThrownInServiceCall_expectedExceptionThrownInResponse() throws Exception {
        BDDMockito.given((Object)this.service.read((BaseServiceRequest)ArgumentMatchers.any())).willThrow(new Throwable[]{new ApplicationClientException("", ErrorCode.GENERIC_4XX_ERROR, new String[0])});
        this.testEndpoint(this.getEndpoint(), HttpMethod.POST, HttpStatus.BAD_REQUEST);
    }

    @Test
    public void read_givenApplicationServerExceptionThrownInServiceCall_expectedExceptionThrownInResponse() throws Exception {
        ClassNotFoundException classNotFoundException = new ClassNotFoundException();
        BDDMockito.given((Object)this.service.read((BaseServiceRequest)ArgumentMatchers.any())).willThrow(new Throwable[]{new ApplicationServerException((Throwable)classNotFoundException)});
        this.testEndpoint(this.getEndpoint(), HttpMethod.POST, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @Test
    public void read_givenNPEThrownInServiceCall_expectedExceptionThrownInResponse() throws Exception {
        BDDMockito.given((Object)this.service.read((BaseServiceRequest)ArgumentMatchers.any())).willThrow(new Throwable[]{new NullPointerException()});
        this.testEndpoint(this.getEndpoint(), HttpMethod.POST, HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

