/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.service.test.controller;

import io.americanexpress.synapse.framework.exception.ApplicationClientException;
import io.americanexpress.synapse.framework.exception.ApplicationServerException;
import io.americanexpress.synapse.framework.exception.model.ErrorCode;
import io.americanexpress.synapse.service.rest.model.BaseServiceRequest;
import io.americanexpress.synapse.service.rest.model.BaseServiceResponse;
import io.americanexpress.synapse.service.rest.service.BaseReadMonoService;
import io.americanexpress.synapse.service.test.controller.BaseControllerUnitTest;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public abstract class BaseReadMonoControllerUnitTest<O extends BaseServiceResponse, I extends BaseServiceRequest, S extends BaseReadMonoService<I, O>>
extends BaseControllerUnitTest<O> {
    @MockBean
    protected S service;

    @Override
    protected String getSampleJsonRequestFileName() {
        return "";
    }

    @Test
    public void read_givenGoodResponseFromService_expectedSuccessfulResponse() throws Exception {
        BDDMockito.given((Object)this.service.read((BaseServiceRequest)ArgumentMatchers.any())).willReturn((Object)this.response);
        this.testEndpoint(this.getEndpoint(), HttpMethod.POST);
    }

    @Test
    public void read_givenEmptyResponseFromService_expectedNoContentResponse() throws Exception {
        BDDMockito.given((Object)this.service.read((BaseServiceRequest)ArgumentMatchers.any())).willReturn(null);
        this.testEndpoint(this.getEndpoint(), HttpMethod.POST, HttpStatus.NO_CONTENT);
    }

    @Test
    public void read_givenApplicationClientExceptionThrownInServiceCall_expectedExceptionThrownInResponse() throws Exception {
        BDDMockito.given((Object)this.service.read((BaseServiceRequest)ArgumentMatchers.any())).willThrow(new Throwable[]{new ApplicationClientException("", ErrorCode.GENERIC_4XX_ERROR, new String[0])});
        this.testEndpoint(this.getEndpoint(), HttpMethod.POST, HttpStatus.BAD_REQUEST);
    }

    @Test
    public void read_givenApplicationServerExceptionThrownInServiceCall_expectedExceptionThrownInResponse() throws Exception {
        ClassNotFoundException classNotFoundException = new ClassNotFoundException();
        BDDMockito.given((Object)this.service.read((BaseServiceRequest)ArgumentMatchers.any())).willThrow(new Throwable[]{new ApplicationServerException((Throwable)classNotFoundException)});
        this.testEndpoint(this.getEndpoint(), HttpMethod.POST, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @Test
    public void read_givenNPEThrownInServiceCall_expectedExceptionThrownInResponse() throws Exception {
        BDDMockito.given((Object)this.service.read((BaseServiceRequest)ArgumentMatchers.any())).willThrow(new Throwable[]{new NullPointerException()});
        this.testEndpoint(this.getEndpoint(), HttpMethod.POST, HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

