/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.service.test.controller;

import io.americanexpress.synapse.framework.exception.ApplicationClientException;
import io.americanexpress.synapse.framework.exception.ApplicationServerException;
import io.americanexpress.synapse.framework.exception.model.ErrorCode;
import io.americanexpress.synapse.service.rest.model.BaseServiceRequest;
import io.americanexpress.synapse.service.rest.model.BaseServiceResponse;
import io.americanexpress.synapse.service.rest.service.BaseUpdateService;
import io.americanexpress.synapse.service.test.controller.BaseControllerUnitTest;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public abstract class BaseUpdateControllerUnitTest<O extends BaseServiceResponse, I extends BaseServiceRequest, S extends BaseUpdateService<I>>
extends BaseControllerUnitTest<O> {
    @MockBean
    protected S service;

    @Override
    protected String getSampleJsonResponseFileName() {
        return "";
    }

    @Test
    public void update_givenVoidFromService_expectedSuccessfulResponse() throws Exception {
        this.testEndpoint(this.getEndpoint(), HttpMethod.PUT, HttpStatus.NO_CONTENT);
    }

    @Test
    public void update_givenApplicationClientExceptionThrownInServiceCall_expectedExceptionThrownInResponse() throws Exception {
        ((BaseUpdateService)Mockito.doThrow((Throwable[])new Throwable[]{new ApplicationClientException("", ErrorCode.GENERIC_4XX_ERROR, new String[0])}).when(this.service)).update((BaseServiceRequest)ArgumentMatchers.any());
        this.testEndpoint(this.getEndpoint(), HttpMethod.PUT, HttpStatus.BAD_REQUEST);
    }

    @Test
    public void update_givenApplicationServerExceptionThrownInServiceCall_expectedExceptionThrownInResponse() throws Exception {
        ClassNotFoundException classNotFoundException = new ClassNotFoundException();
        ((BaseUpdateService)Mockito.doThrow((Throwable[])new Throwable[]{new ApplicationServerException((Throwable)classNotFoundException)}).when(this.service)).update((BaseServiceRequest)ArgumentMatchers.any());
        this.testEndpoint(this.getEndpoint(), HttpMethod.PUT, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @Test
    public void update_givenNPEThrownInServiceCall_expectedExceptionThrownInResponse() throws Exception {
        ((BaseUpdateService)Mockito.doThrow((Throwable[])new Throwable[]{new NullPointerException()}).when(this.service)).update((BaseServiceRequest)ArgumentMatchers.any());
        this.testEndpoint(this.getEndpoint(), HttpMethod.PUT, HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

