/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.service.test.controller;

import io.americanexpress.synapse.framework.exception.ApplicationClientException;
import io.americanexpress.synapse.framework.exception.model.ErrorCode;
import io.americanexpress.synapse.service.rest.model.BaseServiceResponse;
import io.americanexpress.synapse.service.rest.service.BaseDeleteService;
import io.americanexpress.synapse.service.test.controller.BaseControllerUnitTest;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public abstract class BaseDeleteControllerUnitTest<O extends BaseServiceResponse, S extends BaseDeleteService>
extends BaseControllerUnitTest<O> {
    @MockBean
    protected S service;

    @Override
    protected String getSampleJsonRequestFileName() {
        return "";
    }

    @Test
    public void delete_givenGoodResponseFromService_expectedSuccessfulResponse() throws Exception {
        this.testEndpoint(this.getEndpoint() + "/1", HttpMethod.DELETE, HttpStatus.NO_CONTENT);
    }

    @Test
    public void delete_givenExceptionThrownFromServiceCall_expectedExceptionThrownInResponse() throws Exception {
        ((BaseDeleteService)Mockito.doThrow((Throwable[])new Throwable[]{new ApplicationClientException("", ErrorCode.GENERIC_4XX_ERROR, new String[0])}).when(this.service)).delete((String)ArgumentMatchers.any(String.class));
        this.testEndpoint(this.getEndpoint() + "/1", HttpMethod.DELETE, HttpStatus.BAD_REQUEST);
    }

    @Test
    public void delete_givenEmptyResponseFromService_expectedNoContentResponse() throws Exception {
        ((BaseDeleteService)Mockito.doThrow(NullPointerException.class).when(this.service)).delete((String)ArgumentMatchers.any(String.class));
        this.testEndpoint(this.getEndpoint() + "/1", HttpMethod.DELETE, HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

