/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.service.rest.controller.reactive;

import io.americanexpress.synapse.service.rest.controller.BaseController;
import io.americanexpress.synapse.service.rest.model.BaseServiceRequest;
import io.americanexpress.synapse.service.rest.service.reactive.BaseUpdateReactiveService;
import io.swagger.v3.oas.annotations.Operation;
import javax.validation.Valid;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.ResponseStatus;
import reactor.core.publisher.Mono;

public class BaseUpdateReactiveController<I extends BaseServiceRequest, S extends BaseUpdateReactiveService<I>>
extends BaseController<S> {
    @Operation(tags={"Update Operation"}, summary="Updates a resource reactively")
    @PutMapping
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public Mono<ResponseEntity<Void>> update(@RequestHeader HttpHeaders headers, @Valid @RequestBody I serviceRequest) {
        this.logger.entry(new Object[]{serviceRequest});
        Mono<Void> results = ((BaseUpdateReactiveService)this.service).update(headers, serviceRequest);
        Mono responseEntity = results.map(ResponseEntity::ok);
        this.logger.exit();
        return responseEntity;
    }
}

