/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.service.rest.model;

import io.americanexpress.synapse.service.rest.model.BaseServiceResponse;
import io.americanexpress.synapse.service.rest.model.PageInformation;
import java.util.List;

public class PageResponse<O extends BaseServiceResponse> {
    private static final int DEFAULT_PAGE_SIZE = 10;
    private List<O> responses;
    private int totalResultsCount;
    private int pageSize;
    private int page;
    private int startingIndex;
    private int endingIndex;
    private int maxPages;

    public PageResponse(List<O> responses) {
        this.responses = responses;
    }

    public PageResponse(List<O> responses, PageInformation pageInformation) {
        this.responses = responses;
        this.page = pageInformation.getPage();
        this.pageSize = pageInformation.getSize();
        if (this.pageSize < 0) {
            this.pageSize = 10;
        }
        this.totalResultsCount = responses.size();
        if (this.pageSize > this.totalResultsCount) {
            this.pageSize = this.totalResultsCount;
        }
        this.calculatePages();
        this.setPage(this.page);
        this.responses = responses.subList(this.startingIndex, this.endingIndex);
    }

    public List<O> getResponses() {
        return this.responses;
    }

    public void setResponses(List<O> responses) {
        this.responses = responses;
    }

    public int getTotalResultsCount() {
        return this.totalResultsCount;
    }

    public void setTotalResultsCount(int totalResultsCount) {
        this.totalResultsCount = totalResultsCount;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
        this.calculatePages();
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int p) {
        this.page = p >= this.maxPages ? this.maxPages : (p <= 1 ? 1 : p);
        this.startingIndex = this.pageSize * (this.page - 1);
        if (this.startingIndex < 0) {
            this.startingIndex = 0;
        }
        this.endingIndex = this.startingIndex + this.pageSize;
        if (this.endingIndex > this.responses.size()) {
            this.endingIndex = this.responses.size();
        }
    }

    public int getMaxPages() {
        return this.maxPages;
    }

    private void calculatePages() {
        if (this.pageSize > 0) {
            this.maxPages = this.responses.size() % this.pageSize == 0 ? this.responses.size() / this.pageSize : this.responses.size() / this.pageSize + 1;
        }
    }

    public List<O> getResponsesForPage() {
        return this.responses.subList(this.startingIndex, this.endingIndex);
    }
}

