/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.service.rest.controller;

import io.americanexpress.synapse.service.rest.controller.BaseController;
import io.americanexpress.synapse.service.rest.controller.helpers.MonoResponseEntityCreator;
import io.americanexpress.synapse.service.rest.model.BaseServiceRequest;
import io.americanexpress.synapse.service.rest.model.BaseServiceResponse;
import io.americanexpress.synapse.service.rest.service.BaseReadMonoService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import javax.validation.Valid;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;

public abstract class BaseReadMonoController<I extends BaseServiceRequest, O extends BaseServiceResponse, S extends BaseReadMonoService<I, O>>
extends BaseController<S> {
    public static final String INQUIRY_RESULTS = "/inquiry_results";

    @Operation(tags={"Read Mono Operation"}, summary="Read Mono Operation", description="Reads one resource")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @PostMapping(value={"/inquiry_results"})
    public ResponseEntity<O> read(@RequestHeader HttpHeaders headers, @Valid @RequestBody I serviceRequest) {
        this.logger.entry(new Object[]{serviceRequest});
        Object serviceResponse = ((BaseReadMonoService)this.service).read(headers, serviceRequest);
        ResponseEntity responseEntity = MonoResponseEntityCreator.create(serviceResponse);
        this.logger.exit(responseEntity);
        return responseEntity;
    }
}

