/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.service.rest.controller;

import io.americanexpress.synapse.service.rest.controller.BaseController;
import io.americanexpress.synapse.service.rest.controller.helpers.PolyResponseEntityCreator;
import io.americanexpress.synapse.service.rest.model.BaseServiceRequest;
import io.americanexpress.synapse.service.rest.model.BaseServiceResponse;
import io.americanexpress.synapse.service.rest.service.BaseReadPolyService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;

public abstract class BaseReadPolyController<I extends BaseServiceRequest, O extends BaseServiceResponse, S extends BaseReadPolyService<I, O>>
extends BaseController<S> {
    public static final String MULTIPLE_RESULTS = "/multiple_results";

    @Operation(summary="Read operation based on criteria.", description="Read a collection of resources based on request criteria.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @PostMapping(value={"/multiple_results"})
    public ResponseEntity<List<O>> read(@RequestHeader HttpHeaders headers, @Valid @RequestBody I serviceRequest, HttpServletResponse httpServletResponse) {
        this.logger.entry(new Object[]{serviceRequest});
        Page page = ((BaseReadPolyService)this.service).read(headers, serviceRequest);
        ResponseEntity responseEntity = PolyResponseEntityCreator.create(page, httpServletResponse);
        this.logger.exit(responseEntity);
        return responseEntity;
    }
}

