/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.service.rest.controller.reactive;

import io.americanexpress.synapse.service.rest.controller.BaseController;
import io.americanexpress.synapse.service.rest.model.BaseServiceRequest;
import io.americanexpress.synapse.service.rest.model.BaseServiceResponse;
import io.americanexpress.synapse.service.rest.service.reactive.BaseReadPolyReactiveService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import reactor.core.publisher.Flux;

public abstract class BaseReadPolyReactiveController<I extends BaseServiceRequest, O extends BaseServiceResponse, S extends BaseReadPolyReactiveService<I, O>>
extends BaseController<S> {
    public static final String MULTIPLE_RESULTS = "/multiple_results";

    @ApiOperation(value="Reactive Read Poly", notes="Gets a collection of resources", response=ResponseEntity.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Ok"), @ApiResponse(code=204, message="No Content"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden")})
    @PostMapping(value={"/multiple_results"})
    public Flux<ResponseEntity<O>> read(@RequestHeader HttpHeaders headers, @Valid @RequestBody I serviceRequest, HttpServletResponse httpServletResponse) {
        this.logger.entry(new Object[]{serviceRequest});
        Flux serviceResult = ((BaseReadPolyReactiveService)this.service).read(headers, serviceRequest);
        Flux responseEntity = serviceResult.map(ResponseEntity::ok).defaultIfEmpty((Object)ResponseEntity.noContent().build());
        this.logger.exit((Object)responseEntity);
        return responseEntity;
    }
}

