/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.service.rest.controller.reactive;

import io.americanexpress.synapse.service.rest.controller.BaseController;
import io.americanexpress.synapse.service.rest.model.BaseServiceRequest;
import io.americanexpress.synapse.service.rest.model.BaseServiceResponse;
import io.americanexpress.synapse.service.rest.service.reactive.BaseReadMonoReactiveService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.validation.Valid;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import reactor.core.publisher.Mono;

public abstract class BaseReadMonoReactiveController<I extends BaseServiceRequest, O extends BaseServiceResponse, S extends BaseReadMonoReactiveService<I, O>>
extends BaseController<S> {
    public static final String INQUIRY_RESULTS = "/inquiry_results";

    @ApiOperation(value="Reactive Read Mono", notes="Gets one resource")
    @ApiResponses(value={@ApiResponse(code=200, message="Ok"), @ApiResponse(code=204, message="No Content"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden")})
    @PostMapping(value={"/inquiry_results"})
    public Mono<ResponseEntity<O>> read(@RequestHeader HttpHeaders headers, @Valid @RequestBody I serviceRequest) {
        Mono serviceResponse = ((BaseReadMonoReactiveService)this.service).read(headers, serviceRequest);
        Mono responseEntity = serviceResponse.map(ResponseEntity::ok).defaultIfEmpty((Object)ResponseEntity.noContent().build());
        return responseEntity;
    }
}

