/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.service.rest.controller.reactive;

import io.americanexpress.synapse.service.rest.controller.BaseController;
import io.americanexpress.synapse.service.rest.service.reactive.BaseDeleteReactiveService;
import io.swagger.v3.oas.annotations.Operation;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.ResponseStatus;
import reactor.core.publisher.Mono;

public abstract class BaseDeleteReactiveController<S extends BaseDeleteReactiveService>
extends BaseController<S> {
    @DeleteMapping(value={"/{identifier}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(tags={"Delete Operation"}, summary="Deletes a resource reactively")
    public Mono<ResponseEntity<Void>> delete(@RequestHeader HttpHeaders headers, @PathVariable String identifier) {
        this.logger.entry(new Object[]{identifier});
        Mono<Void> serviceResults = ((BaseDeleteReactiveService)this.service).delete(headers, identifier);
        Mono responseEntity = serviceResults.map(res -> new ResponseEntity(HttpStatus.NO_CONTENT));
        this.logger.exit((Object)responseEntity);
        return responseEntity;
    }
}

