/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.service.rest.controller.exceptionhandler;

import io.americanexpress.synapse.framework.exception.ApplicationClientException;
import io.americanexpress.synapse.framework.exception.ApplicationServerException;
import io.americanexpress.synapse.framework.exception.helper.ErrorMessagePropertyReader;
import io.americanexpress.synapse.framework.exception.model.ErrorCode;
import io.americanexpress.synapse.service.rest.controller.exceptionhandler.InputValidationErrorHandler;
import io.americanexpress.synapse.service.rest.model.ErrorResponse;
import io.americanexpress.synapse.utilities.common.cryptography.CryptoUtil;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class ControllerExceptionHandler {
    private final XLogger logger = XLoggerFactory.getXLogger(this.getClass());
    private final ErrorMessagePropertyReader errorMessagePropertyReader;
    private final InputValidationErrorHandler inputValidationErrorHandler;

    public ControllerExceptionHandler(@Autowired ErrorMessagePropertyReader errorMessagePropertyReader, @Autowired InputValidationErrorHandler inputValidationErrorHandler) {
        this.errorMessagePropertyReader = errorMessagePropertyReader;
        this.inputValidationErrorHandler = inputValidationErrorHandler;
    }

    @ExceptionHandler(value={ApplicationServerException.class})
    public ResponseEntity<ErrorResponse> handleApplicationServerException(ApplicationServerException applicationServerException, HttpServletRequest httpServletRequest) {
        this.logger.entry(new Object[]{applicationServerException});
        ResponseEntity<ErrorResponse> errorResponseEntity = this.handleInternalServerError((Throwable)applicationServerException, httpServletRequest);
        this.logger.exit(errorResponseEntity);
        return errorResponseEntity;
    }

    @ExceptionHandler(value={ApplicationClientException.class})
    public ResponseEntity<ErrorResponse> handleApplicationClientException(ApplicationClientException applicationClientException) {
        ResponseEntity errorResponseEntity;
        this.logger.entry(new Object[]{applicationClientException});
        if (applicationClientException.getCause() == null) {
            String[] stringArray;
            ErrorCode errorCode = applicationClientException.getErrorCode();
            if (applicationClientException.getMessageArguments() != null) {
                stringArray = applicationClientException.getMessageArguments();
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "";
            }
            String message = this.errorMessagePropertyReader.getErrorMessage(errorCode, stringArray);
            String developerMessage = StringUtils.isNotBlank((CharSequence)applicationClientException.getDeveloperMessage()) ? applicationClientException.getDeveloperMessage() : "";
            ErrorResponse errorResponse = new ErrorResponse(errorCode, errorCode.getMessage(), message, developerMessage);
            errorResponseEntity = ResponseEntity.status((HttpStatus)errorCode.getHttpStatus()).body((Object)errorResponse);
        } else {
            errorResponseEntity = this.handleInternalServerError((Throwable)applicationClientException);
        }
        this.logger.exit(errorResponseEntity);
        return errorResponseEntity;
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<ErrorResponse> handleMethodArgumentNotValidException(MethodArgumentNotValidException methodArgumentNotValidException) {
        this.logger.warn("Method argument is not valid", (Throwable)methodArgumentNotValidException);
        ErrorResponse errorResponse = this.inputValidationErrorHandler.handleInputValidationErrorMessage(methodArgumentNotValidException.getBindingResult());
        ResponseEntity errorResponseEntity = ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)errorResponse);
        this.logger.exit((Object)errorResponseEntity);
        return errorResponseEntity;
    }

    @ExceptionHandler(value={BindException.class})
    public ResponseEntity<ErrorResponse> handleBindException(BindException bindException) {
        this.logger.warn("Request fields are not valid", (Throwable)bindException);
        ErrorResponse errorResponse = this.inputValidationErrorHandler.handleInputValidationErrorMessage(bindException.getBindingResult());
        ResponseEntity errorResponseEntity = ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)errorResponse);
        this.logger.exit((Object)errorResponseEntity);
        return errorResponseEntity;
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity<ErrorResponse> handleHttpMessageNotReadableException(HttpMessageNotReadableException httpMessageNotReadableException) {
        this.logger.warn("HTTP message is not readable", (Throwable)httpMessageNotReadableException);
        String userMessage = httpMessageNotReadableException.getMessage();
        ErrorCode errorCode = ErrorCode.GENERIC_4XX_ERROR;
        ErrorResponse errorResponse = new ErrorResponse(errorCode, errorCode.getMessage(), userMessage, "Input validation");
        ResponseEntity errorResponseEntity = ResponseEntity.status((HttpStatus)errorCode.getHttpStatus()).body((Object)errorResponse);
        this.logger.exit((Object)errorResponseEntity);
        return errorResponseEntity;
    }

    @ExceptionHandler(value={Throwable.class})
    public ResponseEntity<ErrorResponse> handleThrowable(Throwable throwable) {
        this.logger.catching(throwable);
        ResponseEntity<ErrorResponse> errorResponseEntity = this.handleInternalServerError(throwable);
        this.logger.exit(errorResponseEntity);
        return errorResponseEntity;
    }

    private ResponseEntity<ErrorResponse> handleInternalServerError(Throwable throwable) {
        String message = this.errorMessagePropertyReader.getErrorMessage(ErrorCode.GENERIC_5XX_ERROR, new String[0]);
        String fullStackTrace = ApplicationServerException.getStackTrace((Throwable)throwable, (String)System.lineSeparator());
        ErrorCode errorCode = ErrorCode.GENERIC_5XX_ERROR;
        ErrorResponse errorResponse = new ErrorResponse(errorCode, errorCode.getMessage(), message, CryptoUtil.encrypt((String)fullStackTrace));
        return ResponseEntity.status((HttpStatus)errorCode.getHttpStatus()).body((Object)errorResponse);
    }

    private ResponseEntity<ErrorResponse> handleInternalServerError(Throwable throwable, HttpServletRequest httpServletRequest) {
        this.logger.catching(throwable);
        String message = this.errorMessagePropertyReader.getErrorMessage(ErrorCode.GENERIC_5XX_ERROR, new String[0]);
        String fullStackTrace = ApplicationServerException.getStackTrace((Throwable)throwable, (String)System.lineSeparator());
        ErrorCode errorCode = ErrorCode.GENERIC_5XX_ERROR;
        ErrorResponse errorResponse = new ErrorResponse(errorCode, errorCode.getMessage(), message, CryptoUtil.encrypt((String)fullStackTrace));
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)errorResponse);
    }
}

