/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.service.rest.interceptor;

import io.americanexpress.synapse.framework.exception.ApplicationClientException;
import io.americanexpress.synapse.framework.exception.model.ErrorCode;
import io.americanexpress.synapse.service.rest.model.ServiceHeaderKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;

public abstract class BaseHttpInterceptor
implements HandlerInterceptor {
    private final XLogger logger = XLoggerFactory.getXLogger(this.getClass());
    protected Collection<String> requiredHttpHeaderNames = new ArrayList<String>(Arrays.asList("Content-Type", ServiceHeaderKey.CORRELATION_IDENTIFIER_KEY.getValue(), ServiceHeaderKey.USE_CASE_NAME_KEY.getValue()));

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        this.logger.entry(new Object[]{request, response, handler});
        for (String requiredHttpHeaderName : this.getRequiredHttpHeaderNames()) {
            String httpHeaderValue = request.getHeader(requiredHttpHeaderName);
            if (httpHeaderValue != null) continue;
            throw new ApplicationClientException("Request HTTP Header " + requiredHttpHeaderName + " is missing.", ErrorCode.MISSING_HTTP_HEADER_ERROR, new String[]{requiredHttpHeaderName});
        }
        this.logger.exit();
        return true;
    }

    protected List<String> getRequiredHttpHeaderNames() {
        return new ArrayList<String>();
    }
}

