/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.service.rest.interceptor;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class MetricInterceptor
extends HandlerInterceptorAdapter {
    private final XLogger logger = XLoggerFactory.getXLogger(((Object)((Object)this)).getClass());

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String requestId = UUID.randomUUID().toString();
        this.logger.info("REQUEST ID: {}, HOST: {}, HTTP_METHOD: {}, URI : {}", new Object[]{requestId, request.getHeader("host"), request.getMethod(), request.getRequestURI()});
        long startTime = System.currentTimeMillis();
        request.setAttribute("startTime", (Object)startTime);
        request.setAttribute("requestId", (Object)requestId);
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) throws Exception {
        super.afterCompletion(request, response, handler, exception);
        long startTime = (Long)request.getAttribute("startTime");
        long endTime = System.nanoTime();
        long executeTime = endTime - startTime;
        int status = response.getStatus();
        this.logger.info("RESPONSE TIME: REQUEST_ID: {}, HTTP_METHOD: {}, URI: {}, STATUS: {}, TIME: {} nanoseconds.", new Object[]{request.getAttribute("requestId"), request.getMethod(), request.getRequestURI(), status, executeTime});
    }
}

