/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.service.rest.controller.reactive.helpers;

import io.americanexpress.synapse.service.rest.model.BaseServiceResponse;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;

@Component
public class ReactivePolyResponseEntityCreator<O extends BaseServiceResponse> {
    public ResponseEntity<Flux<O>> create(Page<O> page, HttpServletResponse httpServletResponse) {
        ResponseEntity responseEntity;
        List pageContent = null;
        if (page != null) {
            pageContent = page.getContent();
        }
        if (page == null || CollectionUtils.isEmpty((Collection)pageContent)) {
            responseEntity = new ResponseEntity(HttpStatus.NO_CONTENT);
        } else {
            this.setHeadersInResponse(page, httpServletResponse);
            responseEntity = new ResponseEntity((Object)Flux.fromIterable((Iterable)pageContent), HttpStatus.OK);
        }
        return responseEntity;
    }

    private void setHeadersInResponse(Page<O> page, HttpServletResponse httpServletResponse) {
        if (page != null && !CollectionUtils.isEmpty((Collection)page.getContent())) {
            httpServletResponse.setHeader("size", String.valueOf(page.getSize()));
            httpServletResponse.setHeader("page", String.valueOf(page.getNumber()));
            httpServletResponse.setHeader("total_results_count", String.valueOf(page.getNumberOfElements()));
        }
    }
}

