/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.service.rest.controller.reactive;

import io.americanexpress.synapse.service.rest.controller.BaseController;
import io.americanexpress.synapse.service.rest.controller.reactive.helpers.ReactiveMonoResponseEntityCreator;
import io.americanexpress.synapse.service.rest.model.BaseServiceRequest;
import io.americanexpress.synapse.service.rest.model.BaseServiceResponse;
import io.americanexpress.synapse.service.rest.service.BaseReadMonoService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import reactor.core.publisher.Mono;

public abstract class BaseReactiveReadMonoController<I extends BaseServiceRequest, O extends BaseServiceResponse, S extends BaseReadMonoService<I, O>>
extends BaseController<S> {
    public static final String INQUIRY_RESULTS = "/inquiry_results";
    @Autowired
    private ReactiveMonoResponseEntityCreator<O> reactiveMonoResponseEntityCreator;

    @ApiOperation(value="Reactive Read Mono", notes="Gets one resource")
    @ApiResponses(value={@ApiResponse(code=200, message="Ok"), @ApiResponse(code=204, message="No Content"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden")})
    @PostMapping(value={"/inquiry_results"})
    public ResponseEntity<Mono<O>> read(@Valid @RequestBody I serviceRequest) {
        this.logger.entry(new Object[]{serviceRequest});
        Object serviceResponse = ((BaseReadMonoService)this.service).read(serviceRequest);
        ResponseEntity<Mono<O>> responseEntity = this.reactiveMonoResponseEntityCreator.create(Mono.just(serviceResponse));
        this.logger.exit(responseEntity);
        return responseEntity;
    }
}

