/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.service.rest.controller.reactive;

import io.americanexpress.synapse.service.rest.controller.BaseController;
import io.americanexpress.synapse.service.rest.controller.reactive.helpers.ReactiveCreateResponseEntityCreator;
import io.americanexpress.synapse.service.rest.model.BaseServiceRequest;
import io.americanexpress.synapse.service.rest.model.BaseServiceResponse;
import io.americanexpress.synapse.service.rest.service.BaseCreateService;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.v3.oas.annotations.Operation;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import reactor.core.publisher.Mono;

public abstract class BaseReactiveCreateController<I extends BaseServiceRequest, O extends BaseServiceResponse, S extends BaseCreateService<I, O>>
extends BaseController<S> {
    @Autowired
    private ReactiveCreateResponseEntityCreator<O> reactiveCreateResponseEntityCreator;

    @PostMapping
    @Operation(tags={"Reactive Create Operation"}, summary="Creates a reactive resource")
    @ApiResponses(value={@ApiResponse(code=201, message="Created"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden")})
    public ResponseEntity<Mono<O>> create(@Valid @RequestBody I serviceRequest) {
        this.logger.entry(new Object[]{serviceRequest});
        Object serviceResponse = ((BaseCreateService)this.service).create(serviceRequest);
        ResponseEntity<Mono<O>> responseEntity = this.reactiveCreateResponseEntityCreator.create(serviceResponse);
        this.logger.exit();
        return responseEntity;
    }
}

