/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.service.rest.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.americanexpress.synapse.framework.api.docs.ApiDocsConfig;
import io.americanexpress.synapse.framework.exception.config.ExceptionConfig;
import io.americanexpress.synapse.service.rest.interceptor.MetricInterceptor;
import io.americanexpress.synapse.utilities.common.config.UtilitiesCommonConfig;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ComponentScan(basePackages={"io.americanexpress.synapse.service.rest"})
@Import(value={ExceptionConfig.class, ApiDocsConfig.class, UtilitiesCommonConfig.class})
public class ServiceRestConfig
implements WebMvcConfigurer {
    private final ObjectMapper defaultObjectMapper;
    protected final MetricInterceptor interceptor;

    @Autowired
    public ServiceRestConfig(ObjectMapper defaultObjectMapper, MetricInterceptor interceptor) {
        this.defaultObjectMapper = defaultObjectMapper;
        this.interceptor = interceptor;
    }

    @Bean
    public MappingJackson2HttpMessageConverter jsonMessageConverter() {
        MappingJackson2HttpMessageConverter messageConverter = new MappingJackson2HttpMessageConverter(this.getObjectMapper());
        messageConverter.setSupportedMediaTypes(Collections.singletonList(MediaType.APPLICATION_JSON));
        return messageConverter;
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add((HttpMessageConverter<?>)this.jsonMessageConverter());
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.interceptor).addPathPatterns(new String[]{"/**"});
    }

    protected ObjectMapper getObjectMapper() {
        return this.defaultObjectMapper;
    }
}

