/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.service.reactive.rest.controller.exceptionhandler;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.americanexpress.synapse.framework.exception.ApplicationClientException;
import io.americanexpress.synapse.framework.exception.ApplicationServerException;
import io.americanexpress.synapse.framework.exception.model.ErrorCode;
import io.americanexpress.synapse.service.reactive.rest.controller.exceptionhandler.InputValidationErrorHandler;
import io.americanexpress.synapse.service.reactive.rest.model.ErrorResponse;
import org.reactivestreams.Publisher;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.support.WebExchangeBindException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebInputException;
import org.springframework.web.server.WebExceptionHandler;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
@Order(value=-2)
public class ControllerExceptionHandler
implements WebExceptionHandler {
    private final XLogger logger = XLoggerFactory.getXLogger(this.getClass());
    private final InputValidationErrorHandler inputValidationErrorHandler;

    public Mono<Void> handle(ServerWebExchange exchange, Throwable throwable) {
        ErrorResponse errorResponse = null;
        if (throwable instanceof WebExchangeBindException) {
            WebExchangeBindException webExchangeBindException = (WebExchangeBindException)throwable;
            exchange.getResponse().setStatusCode(HttpStatus.BAD_REQUEST);
            errorResponse = this.inputValidationErrorHandler.handleInputValidationErrorMessage(webExchangeBindException);
        } else if (throwable instanceof ServerWebInputException) {
            ServerWebInputException serverWebInputException = (ServerWebInputException)throwable;
            exchange.getResponse().setStatusCode(HttpStatus.BAD_REQUEST);
            errorResponse = new ErrorResponse(ErrorCode.GENERIC_4XX_ERROR, serverWebInputException.getMessage(), throwable.getMessage(), serverWebInputException.getLocalizedMessage());
        } else if (throwable instanceof ApplicationClientException) {
            ApplicationClientException applicationClientException = (ApplicationClientException)throwable;
            exchange.getResponse().setStatusCode(applicationClientException.getErrorCode().getHttpStatus());
            errorResponse = new ErrorResponse(applicationClientException.getErrorCode(), applicationClientException.getErrorCode().getMessage(), throwable.getMessage(), applicationClientException.getDeveloperMessage());
        } else {
            errorResponse = throwable instanceof ApplicationServerException ? this.handleInternalServerError(throwable) : this.handleInternalServerError(throwable);
        }
        return this.createResponseBody(exchange, errorResponse);
    }

    public Mono<Void> createResponseBody(ServerWebExchange exchange, ErrorResponse errorResponse) {
        DataBuffer buffer;
        try {
            buffer = exchange.getResponse().bufferFactory().wrap(new ObjectMapper().writeValueAsBytes((Object)errorResponse));
        }
        catch (JsonProcessingException exception) {
            throw new ApplicationServerException((Throwable)exception);
        }
        exchange.getResponse().setStatusCode(errorResponse.getCode().getHttpStatus());
        exchange.getResponse().getHeaders().add("Content-Type", "application/json");
        return exchange.getResponse().writeWith((Publisher)Flux.just((Object)buffer));
    }

    public ErrorResponse handleInternalServerError(Throwable throwable) {
        this.logger.warn("Error", throwable);
        return new ErrorResponse(ErrorCode.GENERIC_5XX_ERROR, ErrorCode.GENERIC_5XX_ERROR.getMessage(), throwable.getMessage(), ApplicationServerException.getStackTrace((Throwable)throwable, (String)System.lineSeparator()));
    }

    public ControllerExceptionHandler(InputValidationErrorHandler inputValidationErrorHandler) {
        this.inputValidationErrorHandler = inputValidationErrorHandler;
    }
}

