/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.service.reactive.rest.controller;

import io.americanexpress.synapse.service.reactive.rest.controller.BaseController;
import io.americanexpress.synapse.service.reactive.rest.model.BaseServiceRequest;
import io.americanexpress.synapse.service.reactive.rest.model.BaseServiceResponse;
import io.americanexpress.synapse.service.reactive.rest.service.BaseCreateReactiveService;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.v3.oas.annotations.Operation;
import javax.validation.Valid;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import reactor.core.publisher.Mono;

public abstract class BaseCreateReactiveController<I extends BaseServiceRequest, O extends BaseServiceResponse, S extends BaseCreateReactiveService<I, O>>
extends BaseController<S> {
    @PostMapping
    @Operation(tags={"Reactive Create Operation"}, summary="Creates a reactive resource")
    @ApiResponses(value={@ApiResponse(code=201, message="Created"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden")})
    public Mono<ResponseEntity<O>> create(@RequestHeader HttpHeaders headers, @Valid @RequestBody I serviceRequest) {
        this.logger.entry(new Object[]{serviceRequest});
        Mono serviceResponse = ((BaseCreateReactiveService)this.service).create(headers, serviceRequest);
        Mono responseEntity = serviceResponse.map(arg_0 -> ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.CREATED)).body(arg_0)).defaultIfEmpty((Object)ResponseEntity.noContent().build());
        this.logger.exit();
        return responseEntity;
    }
}

