/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.service.reactive.rest.filter;

import io.americanexpress.synapse.framework.exception.ApplicationClientException;
import io.americanexpress.synapse.framework.exception.model.ErrorCode;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Component
public abstract class BaseHttpHeadersFilter
implements WebFilter {
    private final XLogger logger = XLoggerFactory.getXLogger(this.getClass());

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        this.logger.entry(new Object[]{exchange.getRequest(), exchange.getResponse()});
        if (!this.shouldNotFilter(exchange.getRequest())) {
            for (String requiredHttpHeaderName : this.getRequiredHttpHeaderNames()) {
                String httpHeaderValue = exchange.getRequest().getHeaders().getFirst(requiredHttpHeaderName);
                if (httpHeaderValue != null) continue;
                throw new ApplicationClientException("Request HTTP Header " + requiredHttpHeaderName + " is missing.", ErrorCode.MISSING_HTTP_HEADER_ERROR, new String[]{requiredHttpHeaderName});
            }
        }
        this.logger.exit();
        return chain.filter(exchange);
    }

    protected List<String> getRequiredHttpHeaderNames() {
        return new ArrayList<String>();
    }

    protected boolean shouldNotFilter(ServerHttpRequest request) {
        return false;
    }
}

