/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.service.reactive.rest.controller.exceptionhandler;

import io.americanexpress.synapse.framework.exception.model.ErrorCode;
import io.americanexpress.synapse.service.reactive.rest.model.ErrorResponse;
import java.util.StringJoiner;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.support.WebExchangeBindException;

@Component
public class InputValidationErrorHandler {
    private final XLogger logger = XLoggerFactory.getXLogger(this.getClass());

    public ErrorResponse handleInputValidationErrorMessage(WebExchangeBindException exception) {
        this.logger.entry(new Object[]{exception});
        StringJoiner errorMessageJoiner = new StringJoiner(", ");
        for (FieldError fieldError : exception.getFieldErrors()) {
            String defaultErrorMessage = fieldError.getDefaultMessage();
            String field = fieldError.getField();
            if (!field.contains("Valid")) {
                errorMessageJoiner.add(field + " " + defaultErrorMessage);
                continue;
            }
            errorMessageJoiner.add(defaultErrorMessage);
        }
        ErrorResponse errorResponse = new ErrorResponse(ErrorCode.GENERIC_4XX_ERROR, ErrorCode.GENERIC_4XX_ERROR.getMessage(), errorMessageJoiner.toString(), "Input validation");
        this.logger.exit((Object)errorResponse);
        return errorResponse;
    }
}

