/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.service.reactive.rest.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.americanexpress.synapse.framework.api.docs.ApiDocsConfig;
import io.americanexpress.synapse.framework.exception.config.ExceptionConfig;
import io.americanexpress.synapse.utilities.common.config.UtilitiesCommonConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.util.MimeType;
import org.springframework.web.reactive.config.EnableWebFlux;
import org.springframework.web.reactive.config.WebFluxConfigurer;

@Configuration
@EnableWebFlux
@ComponentScan(basePackages={"io.americanexpress.synapse.service.reactive.rest"})
@Import(value={ExceptionConfig.class, ApiDocsConfig.class, UtilitiesCommonConfig.class})
public class BaseServiceReactiveRestConfig
implements WebFluxConfigurer {
    private final ObjectMapper defaultObjectMapper;

    @Autowired
    public BaseServiceReactiveRestConfig(ObjectMapper defaultObjectMapper) {
        this.defaultObjectMapper = defaultObjectMapper;
    }

    public void configureHttpMessageCodecs(ServerCodecConfigurer configurer) {
        configurer.defaultCodecs().jackson2JsonEncoder((Encoder)new Jackson2JsonEncoder(this.getObjectMapper(), new MimeType[0]));
        configurer.defaultCodecs().jackson2JsonDecoder((Decoder)new Jackson2JsonDecoder(this.getObjectMapper(), new MimeType[0]));
    }

    protected ObjectMapper getObjectMapper() {
        return this.defaultObjectMapper;
    }
}

