/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.service.graphql.pagination;

import graphql.relay.Connection;
import graphql.relay.ConnectionCursor;
import graphql.relay.DefaultConnection;
import graphql.relay.DefaultEdge;
import graphql.relay.DefaultPageInfo;
import graphql.relay.PageInfo;
import io.americanexpress.synapse.service.graphql.model.UniversallyUniqueIdentifiable;
import io.americanexpress.synapse.service.graphql.pagination.ConnectionCursorUtil;
import java.util.List;
import java.util.stream.Collectors;

public final class ConnectionUtil {
    private ConnectionUtil() {
    }

    public static final <T extends UniversallyUniqueIdentifiable> Connection<T> create(List<T> elements, long first, String after) {
        long limit = first > 0L ? first : (long)elements.size();
        List edges = elements.stream().limit(limit).map(element -> new DefaultEdge(element, ConnectionCursorUtil.from(element.getId()))).collect(Collectors.toList());
        ConnectionCursor startCursor = ConnectionCursorUtil.getStartCursor(edges);
        ConnectionCursor endCursor = ConnectionCursorUtil.getEndCursor(edges);
        boolean hasPreviousPage = after != null;
        boolean hasNextPage = (long)edges.size() >= first;
        DefaultPageInfo pageInfo = new DefaultPageInfo(startCursor, endCursor, hasPreviousPage, hasNextPage);
        return new DefaultConnection(edges, (PageInfo)pageInfo);
    }
}

