/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.publisher.kafka.publisher;

import org.springframework.kafka.core.KafkaTemplate;

public abstract class BaseKafkaPublisher {
    private final KafkaTemplate<String, String> kafkaTemplate;

    protected BaseKafkaPublisher(KafkaTemplate<String, String> kafkaTemplate) {
        this.kafkaTemplate = kafkaTemplate;
    }

    public void publish(String message) {
        this.kafkaTemplate.send(this.kafkaTemplate.getDefaultTopic(), (Object)message);
    }

    public void publish(String message, int partition) {
        this.kafkaTemplate.send(this.kafkaTemplate.getDefaultTopic(), Integer.valueOf(partition), null, (Object)message);
    }

    public void publish(String key, String value) {
        this.kafkaTemplate.send(this.kafkaTemplate.getDefaultTopic(), (Object)key, (Object)value);
    }

    public void publish(String key, String value, int partition) {
        this.kafkaTemplate.send(this.kafkaTemplate.getDefaultTopic(), Integer.valueOf(partition), (Object)key, (Object)value);
    }
}

