/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.publisher.kafka.config;

import io.americanexpress.synapse.framework.exception.ApplicationServerException;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.StringSerializer;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.core.env.Environment;
import org.springframework.core.io.FileSystemResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public abstract class BaseKafkaProperties<T extends BaseKafkaTemplate, P extends BaseKafkaProducer<S>, S extends BaseKafkaSsl>
extends KafkaProperties {
    private final T template;
    private final P producer;
    private final S ssl;

    protected BaseKafkaProperties(T template, P producer, S ssl) {
        this.template = template;
        this.producer = producer;
        this.ssl = ssl;
    }

    public P getProducer() {
        return this.producer;
    }

    public T getTemplate() {
        return this.template;
    }

    public S getSsl() {
        return this.ssl;
    }

    public List<String> getBootstrapServers() {
        return this.getProducer().getBootstrapServers();
    }

    public Map<String, Object> buildProducerProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("security.protocol", SecurityProtocol.SSL.name);
        properties.putAll(this.getSsl().buildProperties());
        properties.putAll(this.getProducer().buildProperties());
        return properties;
    }

    public static abstract class BaseKafkaSsl
    extends KafkaProperties.Ssl {
        private final Environment environment;
        private final ResourceLoader resourceLoader;

        protected BaseKafkaSsl(Environment environment) {
            this.environment = environment;
            this.resourceLoader = new FileSystemResourceLoader();
        }

        public String getKeyPassword() {
            return this.environment.getRequiredProperty("key.password");
        }

        public String getKeyStorePassword() {
            return this.environment.getRequiredProperty("keyStore.password");
        }

        public String getKeyStoreType() {
            return this.environment.getRequiredProperty("keyStore.type");
        }

        public Resource getKeyStoreLocation() {
            Resource resource = this.resourceLoader.getResource(this.environment.getRequiredProperty("keyStore.location"));
            if (!resource.exists()) {
                throw new ApplicationServerException((Throwable)new FileNotFoundException(resource.getDescription() + " not found"));
            }
            return resource;
        }

        public Resource getTrustStoreLocation() {
            Resource resource = this.resourceLoader.getResource(this.environment.getRequiredProperty("trustStore.location"));
            if (!resource.exists()) {
                throw new ApplicationServerException((Throwable)new FileNotFoundException(resource.getDescription() + " not found"));
            }
            return resource;
        }

        public String getTrustStorePassword() {
            return this.environment.getRequiredProperty("trustStore.password");
        }

        public String getTrustStoreType() {
            return this.environment.getRequiredProperty("trustStore.type");
        }

        public String getProtocol() {
            return this.environment.getRequiredProperty("protocol");
        }
    }

    public static abstract class BaseKafkaTemplate
    extends KafkaProperties.Template {
        private final Environment environment;

        protected BaseKafkaTemplate(Environment environment) {
            this.environment = environment;
        }

        public String getDefaultTopic() {
            return this.environment.getRequiredProperty("topic.name");
        }
    }

    public static abstract class BaseKafkaProducer<S extends BaseKafkaSsl>
    extends KafkaProperties.Producer {
        private final Environment environment;
        private final S ssl;

        protected BaseKafkaProducer(Environment environment, S ssl) {
            this.environment = environment;
            this.ssl = ssl;
        }

        public S getSsl() {
            return this.ssl;
        }

        public List<String> getBootstrapServers() {
            return Collections.singletonList(this.environment.getRequiredProperty("bootstrap.servers"));
        }

        public Class<?> getKeySerializer() {
            return StringSerializer.class;
        }

        public Class<?> getValueSerializer() {
            return StringSerializer.class;
        }
    }
}

