/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.function.reactive.handler;

import io.americanexpress.synapse.function.reactive.handler.BaseHandler;
import io.americanexpress.synapse.function.reactive.model.BaseFunctionResponse;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;

public abstract class BaseCrudMonoHandler<S extends BaseFunctionResponse>
extends BaseHandler {
    private Class<S> baseFunctionResponse;

    public Mono<ServerResponse> getAll(ServerRequest request) {
        return ServerResponse.ok().contentType(MediaType.APPLICATION_JSON).body(this.executeGetAll(request), this.baseFunctionResponse);
    }

    public Mono<ServerResponse> getById(ServerRequest request) {
        return this.executeGetById(request.pathVariable("id")).flatMap(user -> ServerResponse.ok().contentType(MediaType.APPLICATION_JSON).body(user, this.baseFunctionResponse)).switchIfEmpty(ServerResponse.notFound().build());
    }

    public Mono<ServerResponse> create(ServerRequest request) {
        Mono response = request.bodyToMono(this.baseFunctionResponse);
        return response.flatMap(u -> ServerResponse.status((HttpStatus)HttpStatus.CREATED).contentType(MediaType.APPLICATION_JSON).body(this.executeCreate(u), this.baseFunctionResponse));
    }

    public Mono<ServerResponse> updateById(ServerRequest request) {
        String id = request.pathVariable("id");
        Mono update = request.bodyToMono(this.baseFunctionResponse);
        return update.flatMap(object -> ServerResponse.ok().contentType(MediaType.APPLICATION_JSON).body(this.executeUpdateById(id, object), this.baseFunctionResponse));
    }

    public Mono<ServerResponse> deleteById(ServerRequest request) {
        return this.executeDeleteById(request.pathVariable("id")).flatMap(u -> ServerResponse.ok().body(u, this.baseFunctionResponse)).switchIfEmpty(ServerResponse.notFound().build());
    }

    protected abstract Mono<ServerResponse> executeGetAll(ServerRequest var1);

    protected abstract Mono<ServerResponse> executeCreate(S var1);

    protected abstract Mono<ServerResponse> executeGetById(String var1);

    protected abstract Mono<ServerResponse> executeUpdateById(String var1, S var2);

    protected abstract Mono<ServerResponse> executeDeleteById(String var1);
}

