/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.framework.test.model;

import com.openpojo.reflection.PojoClass;
import com.openpojo.reflection.PojoClassFilter;
import com.openpojo.reflection.filters.FilterEnum;
import com.openpojo.validation.Validator;
import com.openpojo.validation.ValidatorBuilder;
import com.openpojo.validation.rule.Rule;
import com.openpojo.validation.rule.impl.BusinessKeyMustExistRule;
import com.openpojo.validation.rule.impl.EqualsAndHashCodeMatchRule;
import com.openpojo.validation.rule.impl.GetterMustExistRule;
import com.openpojo.validation.rule.impl.SetterMustExistRule;
import com.openpojo.validation.test.Tester;
import com.openpojo.validation.test.impl.BusinessIdentityTester;
import com.openpojo.validation.test.impl.GetterTester;
import com.openpojo.validation.test.impl.SetterTester;
import com.openpojo.validation.test.impl.ToStringTester;
import java.util.ArrayList;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class BaseModelsTest {
    protected String packageName = this.getClass().getPackage().getName();
    protected PojoClassFilter filterTestClasses = new FilterTestClasses();
    protected FilterEnum filterEnum = new FilterEnum();
    protected FilterBasedOnInheritanceTestClasses filterBasedOnInheritanceTestClasses = new FilterBasedOnInheritanceTestClasses();
    protected static Validator validator;

    @BeforeAll
    public static void initialize() {
        validator = ValidatorBuilder.create().with(new Rule[]{new SetterMustExistRule(), new GetterMustExistRule(), new EqualsAndHashCodeMatchRule(), new BusinessKeyMustExistRule()}).with(new Tester[]{new SetterTester(), new GetterTester(), new ToStringTester(), new BusinessIdentityTester()}).build();
    }

    @Test
    protected void validateSettersAndGetters() {
        validator.validateRecursively(this.packageName, new PojoClassFilter[]{this.filterTestClasses, this.filterBasedOnInheritanceTestClasses, this.filterEnum});
    }

    protected static class FilterBasedOnSubClassesCondition
    implements PojoClassFilter {
        protected FilterBasedOnSubClassesCondition() {
        }

        public boolean include(PojoClass pojoClass) {
            return !pojoClass.getName().contains("ProductFilterCode") && !pojoClass.getName().contains("ValidSpendServiceRequest");
        }
    }

    private static class FilterBasedOnInheritanceTestClasses
    implements PojoClassFilter {
        private FilterBasedOnInheritanceTestClasses() {
        }

        public boolean include(PojoClass pojoClass) {
            return !pojoClass.extendz(ArrayList.class);
        }
    }

    private static class FilterTestClasses
    implements PojoClassFilter {
        private FilterTestClasses() {
        }

        public boolean include(PojoClass pojoClass) {
            return !pojoClass.getSourcePath().contains("test");
        }
    }
}

