/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.framework.api.docs;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import org.springdoc.core.GroupedOpenApi;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ApiDocsConfig {
    private static final String teamName = "Team Synapse";
    private static final String teamWebsite = "https://americanexpress.io/synapse/";
    private static final String teamEmailAddress = "synapse@aexp.com";
    public static final String title = "Synapse APIs";
    private static final String description = "These are the specifications of the Synapse APIs";

    @Bean
    public GroupedOpenApi publicApi() {
        return GroupedOpenApi.builder().group("user").pathsToExclude(new String[]{"/api/v2/**", "/v2/**"}).pathsToMatch(new String[]{"/api/v1/**", "/v1/**"}).build();
    }

    @Bean
    public GroupedOpenApi adminApi() {
        return GroupedOpenApi.builder().group("admin").pathsToExclude(new String[]{"/api/v1/**", "/v1/**"}).pathsToMatch(new String[]{"/api/v2/**", "/v2/**"}).build();
    }

    @Bean
    public OpenAPI customOpenAPI() {
        return new OpenAPI().components(new Components()).info(new Info().title(title).description(description).license(new License().name("Apache 2.0").url(teamWebsite)).contact(new Contact().name(teamName).url(teamWebsite).email(teamEmailAddress)));
    }
}

