/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.data.postgres.config;

import com.zaxxer.hikari.HikariDataSource;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
public abstract class BasePostgresDataConfig {
    protected static final String ENTITY_PACKAGE_NAME = ".entity";
    @Autowired
    protected Environment environment;

    public BasePostgresDataConfig(Environment environment) {
        this.environment = environment;
    }

    @Bean
    @ConfigurationProperties(prefix="spring.datasource")
    public DataSource dataSource() {
        HikariDataSource dataSource = (HikariDataSource)DataSourceBuilder.create().type(HikariDataSource.class).build();
        dataSource.setSchema(this.environment.getRequiredProperty("spring.jpa.properties.hibernate.default_schema"));
        dataSource.setLeakDetectionThreshold(2000L);
        dataSource.setDataSourceProperties(this.additionalHibernateSpringProperties());
        return dataSource;
    }

    private Properties additionalHibernateSpringProperties() {
        Properties properties = new Properties();
        properties.setProperty("hibernate.hbm2ddl.auto", this.environment.getRequiredProperty("hibernate.hbm2ddl.auto"));
        properties.setProperty("hibernate.show_sql", this.environment.getRequiredProperty("hibernate.show_sql"));
        properties.setProperty("hibernate.format_sql", this.environment.getRequiredProperty("hibernate.format_sql"));
        properties.setProperty("spring.datasource.initialization-mode", this.environment.getRequiredProperty("spring.datasource.initialization-mode"));
        properties.setProperty("hibernate.cache.use_query_cache", "true");
        properties.setProperty("hibernate.cache.provider_class", "net.sf.ehcache.hibernate.EhCacheProvider");
        return properties;
    }

    @Bean
    public LocalContainerEntityManagerFactoryBean entityManagerFactory() {
        LocalContainerEntityManagerFactoryBean entityManagerFactoryBean = new LocalContainerEntityManagerFactoryBean();
        entityManagerFactoryBean.setDataSource(this.dataSource());
        entityManagerFactoryBean.setJpaVendorAdapter((JpaVendorAdapter)new HibernateJpaVendorAdapter());
        this.setPackagesToScan(entityManagerFactoryBean);
        return entityManagerFactoryBean;
    }

    protected abstract void setPackagesToScan(LocalContainerEntityManagerFactoryBean var1);
}

