/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.data.postgres.entity;

import jakarta.persistence.Column;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Version;
import java.time.LocalDateTime;
import java.util.Objects;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@EntityListeners(value={AuditingEntityListener.class})
@MappedSuperclass
public abstract class BaseEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    protected Long id;
    @CreatedDate
    @Column(name="created_date_time", updatable=false)
    protected LocalDateTime createdDateTime;
    @LastModifiedDate
    @Column(name="last_modified_date_time")
    protected LocalDateTime lastModifiedDateTime;
    @CreatedBy
    @Column(name="created_by")
    protected String createdBy;
    @LastModifiedBy
    @Column(name="last_modified_by")
    protected String lastModifiedBy;
    @Version
    @Column(name="version")
    protected Long version;

    public LocalDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    public void setCreatedDateTime(LocalDateTime createdDate) {
        this.createdDateTime = createdDate;
    }

    public LocalDateTime getLastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public void setLastModifiedDateTime(LocalDateTime lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseEntity that = (BaseEntity)o;
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!Objects.equals(this.createdDateTime, that.createdDateTime)) {
            return false;
        }
        if (!Objects.equals(this.lastModifiedDateTime, that.lastModifiedDateTime)) {
            return false;
        }
        if (!Objects.equals(this.createdBy, that.createdBy)) {
            return false;
        }
        if (!Objects.equals(this.lastModifiedBy, that.lastModifiedBy)) {
            return false;
        }
        return Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.createdDateTime != null ? this.createdDateTime.hashCode() : 0);
        result = 31 * result + (this.lastModifiedDateTime != null ? this.lastModifiedDateTime.hashCode() : 0);
        result = 31 * result + (this.createdBy != null ? this.createdBy.hashCode() : 0);
        result = 31 * result + (this.lastModifiedBy != null ? this.lastModifiedBy.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "BaseEntity{id=" + this.id + ", createdDateTime=" + this.createdDateTime + ", lastModifiedDate=" + this.lastModifiedDateTime + ", createdBy='" + this.createdBy + "', lastModifiedBy='" + this.lastModifiedBy + "', version=" + this.version + "}";
    }
}

