/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.data.oracle.entity;

import jakarta.persistence.Column;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Version;
import java.time.LocalDateTime;
import java.util.Objects;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@EntityListeners(value={AuditingEntityListener.class})
@MappedSuperclass
public abstract class BaseEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    protected Long id;
    @CreatedDate
    @Column(name="created_date_time")
    protected LocalDateTime createdDateTime;
    @LastModifiedDate
    @Column(name="last_modified_date_time")
    protected LocalDateTime lastModifiedDateTime;
    @CreatedBy
    @Column(name="created_by")
    protected String createdBy;
    @LastModifiedBy
    @Column(name="last_modified_by")
    protected String lastModifiedBy;
    @Version
    @Column(name="version")
    protected Long version;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public LocalDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    public void setCreatedDateTime(LocalDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
    }

    public LocalDateTime getLastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public void setLastModifiedDateTime(LocalDateTime lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseEntity that = (BaseEntity)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.createdDateTime, that.createdDateTime) && Objects.equals(this.lastModifiedDateTime, that.lastModifiedDateTime) && Objects.equals(this.createdBy, that.createdBy) && Objects.equals(this.lastModifiedBy, that.lastModifiedBy) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdDateTime, this.lastModifiedDateTime, this.createdBy, this.lastModifiedBy, this.version);
    }

    public String toString() {
        return "BaseEntity{id=" + this.id + ", createdDateTime=" + String.valueOf(this.createdDateTime) + ", lastModifiedDateTime=" + String.valueOf(this.lastModifiedDateTime) + ", createdBy='" + this.createdBy + "', lastModifiedBy='" + this.lastModifiedBy + "', version=" + this.version + "}";
    }
}

