/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.data.oracle.config;

import io.r2dbc.spi.ConnectionFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.r2dbc.ConnectionFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.data.r2dbc.config.AbstractR2dbcConfiguration;
import org.springframework.data.r2dbc.config.EnableR2dbcAuditing;
import org.springframework.r2dbc.connection.R2dbcTransactionManager;
import org.springframework.transaction.ReactiveTransactionManager;

@Configuration
@EnableR2dbcAuditing
public abstract class BaseReactiveOracleConfig
extends AbstractR2dbcConfiguration {
    protected final Environment environment;

    protected BaseReactiveOracleConfig(Environment environment) {
        this.environment = environment;
    }

    @Bean
    @ConfigurationProperties(value="spring.r2dbc")
    public ConnectionFactory connectionFactory() {
        return ConnectionFactoryBuilder.withUrl((String)this.environment.getRequiredProperty("spring.r2dbc.url")).username(this.environment.getRequiredProperty("spring.r2dbc.username")).password((CharSequence)this.environment.getRequiredProperty("spring.r2dbc.password")).build();
    }

    @Bean
    ReactiveTransactionManager transactionManager(ConnectionFactory connectionFactory) {
        return new R2dbcTransactionManager(connectionFactory);
    }
}

