/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.data.oracle.config;

import javax.sql.DataSource;
import oracle.jdbc.pool.OracleDataSource;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableJpaAuditing
@EnableTransactionManagement
public abstract class BaseOracleDataConfig {
    protected final Environment environment;

    protected BaseOracleDataConfig(Environment environment) {
        this.environment = environment;
    }

    @Bean
    @ConfigurationProperties(prefix="spring.datasource")
    public DataSource dataSource() {
        OracleDataSource dataSource = (OracleDataSource)DataSourceBuilder.create().type(OracleDataSource.class).build();
        dataSource.setURL(this.environment.getRequiredProperty("spring.oracle.datasource.url"));
        dataSource.setServerName(this.environment.getRequiredProperty("spring.oracle.datasource.serviceName"));
        dataSource.setUser(this.environment.getRequiredProperty("spring.oracle.datasource.username"));
        dataSource.setPassword(this.environment.getRequiredProperty("spring.oracle.datasource.password"));
        dataSource.setDriverType(this.environment.getRequiredProperty("spring.oracle.datasource.drivertype"));
        return dataSource;
    }

    @Bean
    public LocalContainerEntityManagerFactoryBean entityManagerFactory(DataSource dataSource) {
        LocalContainerEntityManagerFactoryBean entityManagerFactoryBean = new LocalContainerEntityManagerFactoryBean();
        entityManagerFactoryBean.setDataSource(dataSource);
        entityManagerFactoryBean.setJpaVendorAdapter((JpaVendorAdapter)new HibernateJpaVendorAdapter());
        this.setPackagesToScan(entityManagerFactoryBean);
        return entityManagerFactoryBean;
    }

    protected abstract void setPackagesToScan(LocalContainerEntityManagerFactoryBean var1);
}

