/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.data.mysql.config;

import com.mysql.cj.jdbc.MysqlDataSource;
import javax.sql.DataSource;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableJpaAuditing
@EnableTransactionManagement
public abstract class BaseMySqlDataConfig {
    private final Environment environment;

    protected BaseMySqlDataConfig(Environment environment) {
        this.environment = environment;
    }

    @Bean
    @ConfigurationProperties(prefix="spring.datasource")
    public DataSource dataSource() {
        MysqlDataSource dataSource = (MysqlDataSource)DataSourceBuilder.create().type(MysqlDataSource.class).build();
        dataSource.setURL(this.environment.getRequiredProperty("spring.mysql.datasource.url"));
        dataSource.setUser(this.environment.getRequiredProperty("spring.mysql.datasource.username"));
        dataSource.setPassword(this.environment.getRequiredProperty("spring.mysql.datasource.password"));
        return dataSource;
    }

    @Bean
    public LocalContainerEntityManagerFactoryBean entityManagerFactory(DataSource dataSource) {
        LocalContainerEntityManagerFactoryBean entityManagerFactoryBean = new LocalContainerEntityManagerFactoryBean();
        entityManagerFactoryBean.setDataSource(dataSource);
        entityManagerFactoryBean.setJpaVendorAdapter((JpaVendorAdapter)new HibernateJpaVendorAdapter());
        this.setPackagesToScan(entityManagerFactoryBean);
        return entityManagerFactoryBean;
    }

    protected abstract void setPackagesToScan(LocalContainerEntityManagerFactoryBean var1);
}

