/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.data.mongodb.config;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.reactivestreams.client.MongoClient;
import io.americanexpress.synapse.data.mongodb.config.BaseMongoDBConfig;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.config.AbstractReactiveMongoConfiguration;
import org.springframework.data.mongodb.config.EnableReactiveMongoAuditing;

@Configuration
@EnableReactiveMongoAuditing
public abstract class BaseReactiveMongoDBDataConfig
extends AbstractReactiveMongoConfiguration
implements BaseMongoDBConfig {
    protected Environment environment;

    protected BaseReactiveMongoDBDataConfig(Environment environment) {
        this.environment = environment;
    }

    protected String getDatabaseName() {
        return this.environment.getRequiredProperty("spring.data.mongodb.database");
    }

    public MongoClient reactiveMongoClient() {
        ConnectionString connectionString = new ConnectionString(this.environment.getRequiredProperty("spring.data.mongodb.uri"));
        MongoClientSettings mongoClientSettings = this.setMongoClientSettings(connectionString);
        return this.createReactiveMongoClient(mongoClientSettings);
    }
}

