/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.data.mongodb.config;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import io.americanexpress.synapse.data.mongodb.config.BaseMongoDBConfig;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.config.AbstractMongoClientConfiguration;
import org.springframework.data.mongodb.config.EnableMongoAuditing;

@Configuration
@EnableMongoAuditing
public abstract class BaseMongoDBDataConfig
extends AbstractMongoClientConfiguration
implements BaseMongoDBConfig {
    protected Environment environment;

    protected BaseMongoDBDataConfig(Environment environment) {
        this.environment = environment;
    }

    protected String getDatabaseName() {
        return this.environment.getRequiredProperty("spring.data.mongodb.database");
    }

    public MongoClient mongoClient() {
        ConnectionString connectionString = new ConnectionString(this.environment.getRequiredProperty("spring.data.mongodb.uri"));
        MongoClientSettings mongoClientSettings = this.setMongoClientSettings(connectionString);
        return MongoClients.create((MongoClientSettings)mongoClientSettings);
    }
}

