/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.data.db2.config;

import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
public abstract class BaseDb2Config {
    protected final Environment environment;

    protected BaseDb2Config(Environment environment) {
        this.environment = environment;
    }

    @Bean
    public DataSource dataSource() {
        DriverManagerDataSource driverManagerDataSource = new DriverManagerDataSource();
        driverManagerDataSource.setDriverClassName(this.environment.getProperty("spring.datasource.driver-class-name"));
        driverManagerDataSource.setUrl(this.environment.getProperty("spring.datasource.url"));
        driverManagerDataSource.setUsername(this.environment.getProperty("spring.datasource.username"));
        driverManagerDataSource.setPassword(this.environment.getProperty("spring.datasource.password"));
        return driverManagerDataSource;
    }

    @Bean
    @DependsOn(value={"entityManagerFactory"})
    public PlatformTransactionManager transactionManager() {
        JpaTransactionManager jpaTransactionManager = new JpaTransactionManager();
        jpaTransactionManager.setEntityManagerFactory(this.entityManagerFactory().getObject());
        return jpaTransactionManager;
    }

    @Bean
    @DependsOn(value={"dataSource"})
    public LocalContainerEntityManagerFactoryBean entityManagerFactory() {
        LocalContainerEntityManagerFactoryBean entityManagerFactory = new LocalContainerEntityManagerFactoryBean();
        entityManagerFactory.setDataSource(this.dataSource());
        entityManagerFactory.setJpaProperties(this.setJpaProperties());
        entityManagerFactory.setJpaVendorAdapter((JpaVendorAdapter)new HibernateJpaVendorAdapter());
        this.setPackagesToScan(entityManagerFactory);
        return entityManagerFactory;
    }

    private Properties setJpaProperties() {
        Properties jpaProperties = new Properties();
        jpaProperties.put("hibernate.dialect", this.environment.getProperty("spring.jpa.properties.hibernate.dialect"));
        jpaProperties.put("hibernate.hbm2ddl.auto", this.environment.getProperty("spring.jpa.hibernate.ddl-auto"));
        return jpaProperties;
    }

    protected abstract void setPackagesToScan(LocalContainerEntityManagerFactoryBean var1);
}

