/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.data.couchbase.config;

import com.couchbase.client.java.codec.JacksonJsonSerializer;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import org.springframework.core.env.Environment;
import org.springframework.data.couchbase.config.AbstractCouchbaseConfiguration;

public abstract class BaseCouchbaseDataConfig
extends AbstractCouchbaseConfiguration {
    private final Environment environment;
    private final ObjectMapper objectMapper;

    protected BaseCouchbaseDataConfig(Environment environment, ObjectMapper objectMapper) {
        this.environment = environment;
        this.objectMapper = objectMapper;
    }

    protected void configureEnvironment(ClusterEnvironment.Builder builder) {
        builder.timeoutConfig().connectTimeout(Duration.ofSeconds(25L)).queryTimeout(Duration.ofSeconds(10L)).kvTimeout(Duration.ofSeconds(3L)).build();
        builder.jsonSerializer((JsonSerializer)JacksonJsonSerializer.create((ObjectMapper)this.objectMapper)).build();
        builder.loggerConfig().enableDiagnosticContext(true).build();
    }

    public String getConnectionString() {
        return this.environment.getRequiredProperty("spring.couchbase.connection-string");
    }

    public String getUserName() {
        return this.environment.getRequiredProperty("spring.couchbase.username");
    }

    public String getPassword() {
        return this.environment.getRequiredProperty("spring.couchbase.password");
    }

    public String getBucketName() {
        return this.environment.getRequiredProperty("spring.couchbase.bucket-name");
    }

    public String typeKey() {
        return "_dataType";
    }
}

