/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.data.cassandra.config;

import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.data.cassandra.config.AbstractCassandraConfiguration;
import org.springframework.data.cassandra.config.CqlSessionFactoryBean;
import org.springframework.data.cassandra.config.EnableCassandraAuditing;
import org.springframework.data.cassandra.config.SchemaAction;
import org.springframework.data.cassandra.repository.config.EnableCassandraRepositories;

@Configuration
@EnableCassandraRepositories
@EnableCassandraAuditing
public abstract class BaseCassandraDataConfig
extends AbstractCassandraConfiguration {
    private final Environment environment;

    public BaseCassandraDataConfig(Environment environment) {
        this.environment = environment;
    }

    public SchemaAction getSchemaAction() {
        return SchemaAction.valueOf((String)this.environment.getRequiredProperty("spring.data.cassandra.schema-action"));
    }

    protected String getKeyspaceName() {
        return this.environment.getRequiredProperty("spring.data.cassandra.keyspace-name");
    }

    protected String getContactPoints() {
        return this.environment.getRequiredProperty("spring.data.cassandra.contact-points");
    }

    protected int getPort() {
        return Integer.parseInt(this.environment.getRequiredProperty("spring.data.cassandra.port"));
    }

    protected String getLocalDataCenter() {
        return this.environment.getRequiredProperty("spring.data.cassandra.local-datacenter");
    }

    protected String getUserName() {
        return this.environment.getProperty("spring.data.cassandra.username");
    }

    protected String getPassword() {
        return this.environment.getProperty("spring.data.cassandra.password");
    }

    public CqlSessionFactoryBean cassandraSession() {
        CqlSessionFactoryBean bean = super.cassandraSession();
        bean.setUsername(this.getUserName());
        bean.setPassword(this.getPassword());
        return bean;
    }

    public abstract String[] getEntityBasePackages();
}

