/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.client.test.factory;

import io.americanexpress.synapse.client.rest.factory.BaseClientHttpHeadersFactory;
import io.americanexpress.synapse.client.rest.model.BaseClientRequest;
import io.americanexpress.synapse.client.test.client.BaseClientTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;

public abstract class BaseClientHttpHeadersFactoryTest<I extends BaseClientRequest, H extends BaseClientHttpHeadersFactory<I>>
extends BaseClientTest {
    @Autowired
    private H httpHeadersFactory;

    protected void setUrl(String url) {
        this.url = url;
    }

    @Test
    void create_givenNullArguments_expectedNullPointerException() {
        Assertions.assertThrows(NullPointerException.class, () -> this.httpHeadersFactory.create(null, null, null), (String)"Exception not thrown.");
    }

    @Test
    void create_givenNullClientHeaders_expectedNullPointerException() {
        I clientRequest = this.mockDefaultClientRequest();
        Assertions.assertThrows(NullPointerException.class, () -> this.httpHeadersFactory.create(null, clientRequest, this.url), (String)"Exception not thrown.");
    }

    @Test
    void create_givenNullClientRequest_expectedNullPointerException() {
        Assertions.assertThrows(NullPointerException.class, () -> this.httpHeadersFactory.create(new HttpHeaders(), null, this.url), (String)"Exception not thrown.");
    }

    @Test
    void create_givenEmptyClientHeaders_expectedNullPointerException() {
        I clientRequest = this.mockDefaultClientRequest();
        Assertions.assertThrows(NullPointerException.class, () -> this.httpHeadersFactory.create(new HttpHeaders(), clientRequest, this.url), (String)"Exception not thrown.");
    }

    @Test
    void create_givenValidClientHeaders_expectedValidHttpHeaders() throws Exception {
        HttpHeaders clientHeaders = this.getDefaultClientHeaders();
        I clientRequest = this.mockDefaultClientRequest();
        String url = "https://example.com";
        HttpHeaders actual = this.httpHeadersFactory.create(clientHeaders, clientRequest, url);
        Assertions.assertNotNull((Object)actual, (String)"Value is not null.");
    }

    protected abstract void initialize(String var1);

    protected abstract HttpHeaders getDefaultClientHeaders() throws Exception;

    protected abstract I mockDefaultClientRequest();
}

