/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.client.test.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.americanexpress.synapse.client.rest.client.BaseReactiveRestClient;
import io.americanexpress.synapse.client.rest.factory.BaseClientHttpHeadersFactory;
import io.americanexpress.synapse.client.rest.model.BaseClientRequest;
import io.americanexpress.synapse.client.rest.model.BaseClientResponse;
import io.americanexpress.synapse.client.test.client.BaseClientTest;
import io.americanexpress.synapse.framework.exception.ApplicationServerException;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

public abstract class BaseReactiveRestClientUnitTest<I extends BaseClientRequest, O extends BaseClientResponse, H extends BaseClientHttpHeadersFactory<I>, C extends BaseReactiveRestClient<I, O, H>>
extends BaseClientTest {
    @Autowired
    C client;

    @Test
    void callMonoService_givenValidRequest_expectedValidResponse() {
        WebClient webClient = WebClient.builder().exchangeFunction(clientRequest -> {
            try {
                return Mono.just((Object)ClientResponse.create((HttpStatus)HttpStatus.OK).header("Content-Type", new String[]{"application/json"}).body(this.mapper.writeValueAsString(this.mockDefaultClientResponse())).build());
            }
            catch (JsonProcessingException exception) {
                throw new ApplicationServerException((Throwable)exception);
            }
        }).build();
        this.client.setWebClient(webClient);
        Mono clientResponse = this.client.callMonoService(this.mockClientHeaders(), this.mockDefaultClientRequest(), new String[]{this.mockPathVariables()});
        StepVerifier.create((Publisher)clientResponse).expectNextCount(1L).expectComplete().verify();
    }

    public abstract I mockDefaultClientRequest();

    public abstract O mockDefaultClientResponse();

    public abstract HttpHeaders mockClientHeaders();

    public abstract String mockPathVariables();
}

