/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.client.test.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.americanexpress.synapse.client.rest.client.BaseRestClient;
import io.americanexpress.synapse.client.rest.factory.BaseClientHttpHeadersFactory;
import io.americanexpress.synapse.client.rest.model.BaseClientRequest;
import io.americanexpress.synapse.client.rest.model.BaseClientResponse;
import io.americanexpress.synapse.client.rest.model.ClientHeaders;
import io.americanexpress.synapse.client.rest.model.QueryParameter;
import io.americanexpress.synapse.client.test.client.BaseRestClientTest;
import io.americanexpress.synapse.framework.exception.ApplicationClientException;
import io.americanexpress.synapse.framework.exception.ApplicationServerException;
import io.americanexpress.synapse.framework.exception.model.ErrorCode;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.test.web.client.ExpectedCount;
import org.springframework.test.web.client.MockRestServiceServer;
import org.springframework.test.web.client.ResponseActions;
import org.springframework.test.web.client.ResponseCreator;
import org.springframework.test.web.client.match.MockRestRequestMatchers;
import org.springframework.test.web.client.response.MockRestResponseCreators;
import org.springframework.web.client.RestTemplate;

public abstract class BaseRestClientUnitTest<I extends BaseClientRequest, O extends BaseClientResponse, H extends BaseClientHttpHeadersFactory<I>, C extends BaseRestClient<I, O, H>>
extends BaseRestClientTest<I, O, H, C> {
    protected O clientResponse;
    protected ClientHeaders clientHeaders;
    protected MockRestServiceServer mockServer;
    protected ResponseActions responseActions;

    @BeforeEach
    void init() throws Exception {
        this.clientRequest = this.mockDefaultClientRequest();
        this.clientResponse = this.mockDefaultClientResponse();
        this.clientHeaders = this.getDefaultClientHeaders();
        this.mockServer = this.getMockServer();
        this.responseActions = this.getResponseActions(this.mockServer, this.url);
    }

    @Test
    void callMonoService_givenValidClientRequest_expectedNonNullClientResponse() throws JsonProcessingException {
        this.responseActions.andRespond((ResponseCreator)MockRestResponseCreators.withStatus((HttpStatus)HttpStatus.OK).contentType(MediaType.APPLICATION_JSON).body(this.mapper.writeValueAsString(this.clientResponse)));
        BaseClientResponse actual = this.restClient.callMonoService(this.clientHeaders, this.clientRequest, new String[0]);
        this.mockServer.verify();
        Assertions.assertNotNull((Object)actual, (String)"Response is null.");
        this.logger.debug("Client response {}", (Object)actual);
    }

    @Test
    void callMonoService_givenClientRequestWithPathVariable_expectedNonNullClientResponse() throws JsonProcessingException {
        MockRestServiceServer pathVariableMockServer = this.getMockServer();
        ResponseActions pathVariableResponseActions = this.getResponseActions(pathVariableMockServer, this.url + "/" + this.mockPathVariable());
        pathVariableResponseActions.andRespond((ResponseCreator)MockRestResponseCreators.withStatus((HttpStatus)HttpStatus.OK).contentType(MediaType.APPLICATION_JSON).body(this.mapper.writeValueAsString(this.clientResponse)));
        BaseClientResponse actual = this.restClient.callMonoService(this.clientHeaders, this.clientRequest, new String[]{this.mockPathVariable()});
        pathVariableMockServer.verify();
        Assertions.assertNotNull((Object)actual, (String)"Response is null.");
        this.logger.debug("Client response {}", (Object)actual);
    }

    @Test
    void callMonoService_givenClientRequestWithQueryParameter_expectedNonNullClientResponse() throws JsonProcessingException {
        MockRestServiceServer queryParameterMockServer = this.getMockServer();
        ResponseActions pathVariableResponseActions = this.getResponseActions(queryParameterMockServer, this.url + "?name=bob");
        pathVariableResponseActions.andRespond((ResponseCreator)MockRestResponseCreators.withStatus((HttpStatus)HttpStatus.OK).contentType(MediaType.APPLICATION_JSON).body(this.mapper.writeValueAsString(this.clientResponse)));
        BaseClientResponse actual = this.restClient.callMonoService(this.clientHeaders, this.clientRequest, this.mockQueryParameter(), new String[0]);
        queryParameterMockServer.verify();
        Assertions.assertNotNull((Object)actual, (String)"Response is null.");
        this.logger.debug("Client response {}", (Object)actual);
    }

    @Test
    void callMonoService_givenClientRequestWithPathVariableAndQueryParameter_expectedNonNullClientResponse() throws JsonProcessingException {
        MockRestServiceServer queryParameterMockServer = this.getMockServer();
        ResponseActions pathVariableResponseActions = this.getResponseActions(queryParameterMockServer, this.url + "/" + this.mockPathVariable() + "?name=bob");
        pathVariableResponseActions.andRespond((ResponseCreator)MockRestResponseCreators.withStatus((HttpStatus)HttpStatus.OK).contentType(MediaType.APPLICATION_JSON).body(this.mapper.writeValueAsString(this.clientResponse)));
        BaseClientResponse actual = this.restClient.callMonoService(this.clientHeaders, this.clientRequest, this.mockQueryParameter(), new String[]{this.mockPathVariable()});
        queryParameterMockServer.verify();
        Assertions.assertNotNull((Object)actual, (String)"Response is null.");
        this.logger.debug("Client response {}", (Object)actual);
    }

    @Test
    void callMonoService_givenClientError_expectedApplicationClientException() throws IOException {
        this.responseActions.andRespond((ResponseCreator)MockRestResponseCreators.withStatus((HttpStatus)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_JSON).body(this.mapper.writeValueAsString(this.clientResponse)));
        Assertions.assertThrows(ApplicationClientException.class, this::callMonoServiceAndAssertErrorResponse, (String)"Exception not thrown.");
    }

    @Test
    void callMonoService_givenServerError_expectedApplicationClientException() throws IOException {
        this.responseActions.andRespond((ResponseCreator)MockRestResponseCreators.withStatus((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.APPLICATION_JSON).body(this.mapper.writeValueAsString(this.clientResponse)));
        Assertions.assertThrows(ApplicationServerException.class, this::callMonoServiceAndAssertErrorResponse, (String)"Exception not thrown.");
    }

    private MockRestServiceServer getMockServer() {
        return MockRestServiceServer.bindTo((RestTemplate)this.restClient.getRestTemplate()).ignoreExpectOrder(true).bufferContent().build();
    }

    private ResponseActions getResponseActions(MockRestServiceServer mockServer, String url) {
        URI uri = URI.create(url);
        return mockServer.expect(ExpectedCount.once(), MockRestRequestMatchers.requestTo((URI)uri)).andExpect(MockRestRequestMatchers.method((HttpMethod)this.restClient.getHttpMethod()));
    }

    private List<QueryParameter> mockQueryParameter() {
        ArrayList<QueryParameter> queryParameters = new ArrayList<QueryParameter>();
        QueryParameter queryParameter = new QueryParameter("name", "bob");
        queryParameters.add(queryParameter);
        return queryParameters;
    }

    private String mockPathVariable() {
        return "11111111111";
    }

    private void callMonoServiceAndAssertErrorResponse() {
        try {
            this.restClient.callMonoService(this.clientHeaders, this.clientRequest, new String[0]);
            this.mockServer.verify();
        }
        catch (ApplicationClientException applicationClientException) {
            Assert.assertEquals((Object)ErrorCode.GENERIC_4XX_ERROR, (Object)applicationClientException.getErrorCode());
            throw applicationClientException;
        }
    }

    protected abstract I mockDefaultClientRequest();

    protected abstract O mockDefaultClientResponse();

    protected abstract ClientHeaders getDefaultClientHeaders() throws Exception;
}

