/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.client.rest.helper;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.util.MimeType;
import org.springframework.util.StreamUtils;

@Component
public class RestClientLogFormatter {
    public String formatClientRequest(HttpRequest httpRequest, byte[] bodyBytes) {
        URI uri = httpRequest.getURI();
        HttpMethod httpMethod = httpRequest.getMethod();
        HttpHeaders httpHeaders = httpRequest.getHeaders();
        String formattedClientRequest = new String(bodyBytes, this.getCharset((HttpMessage)httpRequest));
        return String.format("Client Request: URI=%s, HTTP Method=%s, HTTP Headers=%s, Request=%s", uri, httpMethod, httpHeaders, formattedClientRequest);
    }

    public String formatClientResponse(ClientHttpResponse clientHttpResponse) throws IOException {
        HttpStatus httpStatus = clientHttpResponse.getStatusCode();
        HttpHeaders httpHeaders = clientHttpResponse.getHeaders();
        String formattedClientResponse = new String(StreamUtils.copyToByteArray((InputStream)clientHttpResponse.getBody()), this.getCharset((HttpMessage)clientHttpResponse));
        return String.format("Client Response: HTTP Status=%s, HTTP Headers=%s, Response=%s", httpStatus, httpHeaders, formattedClientResponse);
    }

    private Charset getCharset(HttpMessage httpMessage) {
        return Optional.ofNullable(httpMessage).map(HttpMessage::getHeaders).map(HttpHeaders::getContentType).map(MimeType::getCharset).orElse(StandardCharsets.ISO_8859_1);
    }
}

