/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.client.rest.client;

import io.americanexpress.synapse.client.rest.client.BaseClient;
import io.americanexpress.synapse.client.rest.handler.BaseReactiveRestResponseErrorHandler;
import io.americanexpress.synapse.client.rest.helper.UrlBuilder;
import io.americanexpress.synapse.client.rest.model.BaseClientRequest;
import io.americanexpress.synapse.client.rest.model.BaseClientResponse;
import io.americanexpress.synapse.client.rest.model.QueryParameter;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class BaseReactiveRestClient<I extends BaseClientRequest, O extends BaseClientResponse>
extends BaseClient<I, O> {
    protected final BaseReactiveRestResponseErrorHandler reactiveRestResponseErrorHandler;
    protected WebClient webClient;

    protected BaseReactiveRestClient(HttpMethod httpMethod, BaseReactiveRestResponseErrorHandler reactiveRestResponseErrorHandler) {
        super(httpMethod);
        this.reactiveRestResponseErrorHandler = reactiveRestResponseErrorHandler;
    }

    public WebClient getWebClient() {
        return this.webClient;
    }

    public void setWebClient(WebClient webClient) {
        this.webClient = webClient;
    }

    public Mono<O> callMonoService(HttpHeaders headers, I clientRequest, String ... pathVariables) {
        return this.callMonoService(headers, clientRequest, (List<QueryParameter>)null, pathVariables);
    }

    public Mono<O> callMonoService(HttpHeaders headers, I clientRequest, List<QueryParameter> queryParameters, String ... pathVariables) {
        String updatedUrl = UrlBuilder.build(this.url, queryParameters, pathVariables);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.method(this.httpMethod).uri(updatedUrl, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).body((Publisher)Mono.just(clientRequest), this.clientRequestType).retrieve().onStatus(HttpStatus::isError, this.reactiveRestResponseErrorHandler::apply).bodyToMono(this.clientResponseType);
    }

    public Flux<O> callPolyService(HttpHeaders headers, I clientRequest, String ... pathVariables) {
        return this.callPolyService(headers, clientRequest, (List<QueryParameter>)null, pathVariables);
    }

    public Flux<O> callPolyService(HttpHeaders headers, I clientRequest, List<QueryParameter> queryParameters, String ... pathVariables) {
        String updatedUrl = UrlBuilder.build(this.url, queryParameters, pathVariables);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.method(this.httpMethod).uri(updatedUrl, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).body((Publisher)Flux.just(clientRequest), this.clientRequestType).retrieve().onStatus(HttpStatus::isError, this.reactiveRestResponseErrorHandler::apply).bodyToFlux(this.clientResponseType);
    }
}

