/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.client.rest.client;

import io.americanexpress.synapse.client.rest.client.BaseReactiveRestClient;
import io.americanexpress.synapse.client.rest.handler.BaseReactiveRestResponseErrorHandler;
import io.americanexpress.synapse.client.rest.helper.UrlBuilder;
import io.americanexpress.synapse.client.rest.model.BaseClientRequest;
import io.americanexpress.synapse.client.rest.model.BaseClientResponse;
import io.americanexpress.synapse.client.rest.model.QueryParameter;
import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class BaseGetReactiveRestClient<I extends BaseClientRequest, O extends BaseClientResponse>
extends BaseReactiveRestClient<I, O> {
    protected BaseGetReactiveRestClient(BaseReactiveRestResponseErrorHandler reactiveRestResponseErrorHandler) {
        super(HttpMethod.GET, reactiveRestResponseErrorHandler);
    }

    @Override
    public Mono<O> callMonoService(HttpHeaders headers, I clientRequest, List<QueryParameter> queryParameters, String ... pathVariables) {
        String updatedUrl = UrlBuilder.build(this.url, queryParameters, pathVariables);
        return this.webClient.get().uri(updatedUrl, new Object[0]).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers)).retrieve().onStatus(HttpStatus::isError, this.reactiveRestResponseErrorHandler::apply).bodyToMono(this.clientResponseType);
    }

    @Override
    public Flux<O> callPolyService(HttpHeaders headers, I clientRequest, List<QueryParameter> queryParameters, String ... pathVariables) {
        String updatedUrl = UrlBuilder.build(this.url, queryParameters, pathVariables);
        return this.webClient.get().uri(updatedUrl, new Object[0]).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers)).retrieve().onStatus(HttpStatus::isError, this.reactiveRestResponseErrorHandler::apply).bodyToFlux(this.clientResponseType);
    }
}

