/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.client.rest.client;

import io.americanexpress.synapse.client.rest.factory.BaseClientHttpHeadersFactory;
import io.americanexpress.synapse.client.rest.model.BaseClientRequest;
import io.americanexpress.synapse.client.rest.model.BaseClientResponse;
import java.lang.reflect.ParameterizedType;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.springframework.http.HttpMethod;

abstract class BaseClient<I extends BaseClientRequest, O extends BaseClientResponse, H extends BaseClientHttpHeadersFactory<I>> {
    protected final XLogger logger = XLoggerFactory.getXLogger(this.getClass());
    protected final H httpHeadersFactory;
    protected Class<I> clientRequestType;
    protected Class<O> clientResponseType;
    protected HttpMethod httpMethod;
    protected String url;

    protected BaseClient(H httpHeadersFactory, HttpMethod httpMethod) {
        this.httpHeadersFactory = httpHeadersFactory;
        this.httpMethod = httpMethod;
        this.initialize();
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    private void initialize() {
        Class<?> classType = this.getClass();
        while (classType.getSuperclass() != BaseClient.class) {
            classType = classType.getSuperclass();
        }
        ParameterizedType parameterizedType = (ParameterizedType)this.getClass().getGenericSuperclass();
        this.clientRequestType = (Class)parameterizedType.getActualTypeArguments()[0];
        this.clientResponseType = (Class)parameterizedType.getActualTypeArguments()[1];
    }
}

