/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.client.rest.helper;

import io.americanexpress.synapse.client.rest.helper.RestClientLogFormatter;
import java.io.IOException;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Component;

@Component
public class RestClientLoggingInterceptor
implements ClientHttpRequestInterceptor {
    private final XLogger logger = XLoggerFactory.getXLogger(this.getClass());
    private final RestClientLogFormatter restClientLogFormatter;

    @Autowired
    public RestClientLoggingInterceptor(RestClientLogFormatter restClientLogFormatter) {
        this.restClientLogFormatter = restClientLogFormatter;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        ClientHttpResponse response = execution.execute(request, body);
        HttpStatus.Series httpStatusSeries = ((HttpStatus)response.getStatusCode()).series();
        if (httpStatusSeries == HttpStatus.Series.CLIENT_ERROR || httpStatusSeries == HttpStatus.Series.SERVER_ERROR) {
            this.logger.info(this.restClientLogFormatter.formatClientRequest(request, body));
            this.logger.info(this.restClientLogFormatter.formatClientResponse(response));
        }
        return response;
    }
}

