/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.client.rest.handler;

import io.americanexpress.synapse.client.rest.handler.BaseResponseErrorHandler;
import io.americanexpress.synapse.framework.exception.ApplicationClientException;
import io.americanexpress.synapse.framework.exception.model.ErrorCode;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StreamUtils;
import org.springframework.web.client.ResponseErrorHandler;

public abstract class BaseRestResponseErrorHandler
extends BaseResponseErrorHandler
implements ResponseErrorHandler {
    public boolean hasError(ClientHttpResponse httpResponse) throws IOException {
        return ((HttpStatus)httpResponse.getStatusCode()).series() == HttpStatus.Series.CLIENT_ERROR || ((HttpStatus)httpResponse.getStatusCode()).series() == HttpStatus.Series.SERVER_ERROR;
    }

    public void handleError(ClientHttpResponse httpResponse) throws IOException {
        String responseBody = this.getResponseBodyAsString(httpResponse);
        String developerMessage = this.buildDeveloperMessage(httpResponse.getStatusCode(), responseBody);
        this.logError(httpResponse, developerMessage);
        throw new ApplicationClientException(developerMessage, ErrorCode.GENERIC_4XX_ERROR, new String[0]);
    }

    protected void logError(ClientHttpResponse httpResponse, String developerMessage) throws IOException {
        if (((HttpStatus)httpResponse.getStatusCode()).series() == HttpStatus.Series.SERVER_ERROR) {
            this.logger.error(developerMessage);
        }
    }

    protected String getResponseBodyAsString(ClientHttpResponse response) throws IOException {
        return StreamUtils.copyToString((InputStream)response.getBody(), (Charset)Charset.defaultCharset());
    }
}

